
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1331.C - Message 1331 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1331 messages.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\MSG1331.C_V  $
//   
//      Rev 1.15   09 Nov 1998 10:48:08   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//      Rev 1.3   Jul 09 1997 10:56:12   COLEJ
//    
//   
//      Rev 1.2   Feb 12 1997 16:05:50   COLEJ
//    
//   
//      Rev 1.1   Aug 13 1996 15:03:16   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:53:20   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#include <string.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"
#include "util.h"   

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1331 message from the ZMsgBuf.
//
void Dec1331(tMSGBUF *ZMsgBuf, tMSG1331 *Msg)
{

}                                      
                                     
////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1331 message in the ZMsgBuf. 
//
void Bld1331(tMSGBUF *ZMsgBuf, tMSG1331 *Msg)
{
   // copy message into buffer
   memcpy(((tSHORT *) ZMsgBuf)+5, Msg, sizeof(*Msg));          

   // build the header in the buffer
   PutShort  (0x81FF                        , ZMsgBuf, 1);     // message preamble
   PutShort  (1331                          , ZMsgBuf, 2);     // message number
   PutShort  (3                             , ZMsgBuf, 3);     // message length 
   PutShort  (ANREQ                         , ZMsgBuf, 4);     // message ack/nack request
}
